﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminListUsers.aspx.cs" Inherits="AdminListUsers" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    
    <div class="breadcrumb">
        <asp:Label ID = "BreadCrumbLabel" runat="server" Text="Administration > Users"/>
    </div>    
    
    <div class = "excludeSaveWarnings">
    <p>
        <br />
        <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search:</asp:Label>
                                
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="100"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" Search "
            OnClick = "OKButton_Click" />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
            onclick="ButtonClear_Click" />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </p>
    <p>
        <asp:GridView ID="GridViewUsers" runat="server" DataKeyNames="USER_ID"
            DataSourceID="ObjectDataSourceUsers" AutoGenerateColumns="False" 
            AllowPaging="True"
            AllowSorting="True" Caption="Users" EmptyDataText="No Users"  
            OnRowCommand = "GridViewUsers_RowCommand">
            <Columns>
                <asp:HyperLinkField DataNavigateUrlFields="USER_ID" SortExpression="USER_ID" NavigateUrl="~/AdminEditUsersRoles.aspx"
                    ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                    DataNavigateUrlFormatString="AdminEditUsers.aspx?id={0}"
                    DataTextField="USER_ID" HeaderText="Id">
                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                </asp:HyperLinkField>
                <asp:BoundField DataField="USERNAME" HeaderText="NT Username"  ItemStyle-Width="150px"
                    SortExpression="USERNAME" >
                    <ItemStyle Width="150px"></ItemStyle>
                </asp:BoundField>
                <asp:BoundField DataField="FULL_NAME" HeaderText="Name" ItemStyle-Width="250px"
                    SortExpression="LAST_NAME" >
                    <ItemStyle Width="250px"></ItemStyle>
                </asp:BoundField>
                <asp:ButtonField ButtonType = "Button" Text = "Edit" CommandName = "Edit" AccessibleHeaderText = "Edit"  />
                <asp:ButtonField ButtonType = "Button" Text = "Edit Roles" CommandName = "Edit Roles" AccessibleHeaderText = "Edit Roles"  />
                
                <asp:TemplateField  AccessibleHeaderText = "Remove">
                    <ItemTemplate>
                        <asp:Button ID="RemoveButton" Runat="server" 
                            OnClientClick="return confirm('Are you sure you want to remove this user?');"
                            CommandName="Delete" Text="Remove" />
                    </ItemTemplate>
                </asp:TemplateField>

            </Columns>
        </asp:GridView>
        <br />
        <asp:Button ID="ButtonAddUser" runat="server" Text="  Add User  " PostBackUrl="~/AdminEditUsers.aspx" />
        <asp:ObjectDataSource ID="ObjectDataSourceUsers" runat="server" 
            SelectMethod="SelectListRegistryUsers" 
            SelectCountMethod="SelectListRegistryUsersCount"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager" 
            DeleteMethod="RemoveUserFromRegistry">
            <DeleteParameters>
                <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="EFR" 
                    Name="RegistryCode" PropertyName="Value" Type="String" />
            </DeleteParameters>
            <SelectParameters>
                <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="EFR" 
                    Name="RegistryCode" PropertyName="Value" Type="String" />
                <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue=""
                    Name="searchCriteria" PropertyName="Text" Type="String" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
           
        <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />
    </p>
    </div>
</asp:Content>

